#version 450
#pragma shader_stage(compute)

layout(local_size_x = 16, local_size_y = 16) in;

// binding = 0: camera
layout(binding = 0) uniform Camera {
    mat4 viewProjectionMatrix; // 视图投影矩阵
    vec3 cameraPosition;       // 摄像机位置
};
// binding = 1: output image (储存最终颜色)
layout(binding = 1, rgba8) uniform writeonly image2D resultImage;

void main() {
    uvec2 pixelCoord = gl_GlobalInvocationID.xy;

    ivec2 imageSize = imageSize(resultImage);

    if (pixelCoord.x >= imageSize.x || pixelCoord.y >= imageSize.y)
        return;

    // 简单测试颜色：基于像素坐标生成一个红-绿渐变
    vec4 color = vec4(
        float(pixelCoord.x) / float(imageSize.x),
        float(pixelCoord.y) / float(imageSize.y),
        0.0,
        1.0
    );

    imageStore(resultImage, ivec2(pixelCoord), color);
}
